<?php
/*
Plugin Name: Buttons X - Live Composer
Plugin URI: https://www.button.sx/
Description: Live Composer add-on for Buttons X.
Version: 0.1
Author: Gautam Thapar
Author URI: http://gautamthapar.me/
License: Envato Split license
Text Domain: btnsx-lc
Domain Path: /languages
*/

// Make sure we don't expose any info if called directly
if ( !defined( 'ABSPATH' ) ){
	exit;
}

define( 'BTNSX__LC_VERSION', '0.1' );
define( 'BTNSX__LC_PLUGIN_URL', plugin_dir_url( __FILE__ ) );
define( 'BTNSX__LC_PLUGIN_DIR', plugin_dir_path( __FILE__ ) );

/**
 * Returns post title and id as select choices
 * @since  0.1
 * @param  string/array    $type
 * @return array
 */
function btnsx_lc_post_types( $type ){
	$choices = array();
	$args = array(
        'post_type' => $type,
        'post_status' => 'publish',
        'posts_per_page' => -1
    );
    $the_query = new WP_Query( $args );
    // The Loop
    if ( $the_query->have_posts() ) {
        while ( $the_query->have_posts() ) {
            $the_query->the_post();
            $choices[] = array(
            	'label' => get_the_title(),
            	'value' => get_the_id()
            );
        }
    } else {
        // no downloads found
        $choices[] = array(
        	'label' => __('Nothing found','btnsx-lc'),
        	'value' => ''
        );
    }
    /* Restore original Post Data */
    wp_reset_postdata();
    return $choices;
}

/**
 * Menus as choices
 * @since  0.1
 * @return array
 */
function btnsx_lc_menus(){
	$menus = get_terms('nav_menu');
	$choices = array();
	$choices[] = array(
		'label' => __( 'Default', 'btnsx-lc' ),
		'value' => ''
	);
	foreach( $menus as $menu ){
		$choices[] = array(
			'label' => $menu->name,
			'value' => $menu->name
		);
	}
	return $choices;
}

/**
 * Post types as links as choices
 * @since  0.1
 * @param  string    $selected
 * @return array
 */
function btnsx_lc_post_links(){
	$post_types = get_post_types( array( 'public' => true ) );
	$options = array();
	foreach ( $post_types as $key => $type ) {
		if( !in_array( $type, array( 'buttons-x', 'buttons-x-social', 'buttons-x-dual', 'buttons-x-cs' ) ) ) {
			$args = array(
				'post_type' => $type,
				'post_status' => 'publish',
				'posts_per_page' => -1
			);
			$query = new WP_Query( $args );
			// The Loop
			if ( $query->have_posts() ) {
				while ( $query->have_posts() ) {
					$query->the_post();
					$options[ get_permalink() ] = get_the_title();
				}
			} else {
				// no posts found
			}
			/* Restore original Post Data */
			wp_reset_postdata();
		}
	}
	$choices = array();
	foreach ($options as $key => $value) {
		$choices[] = array(
            'label' => $value,
            'value' => $key
        );
	}
	return $choices;
}

/**
 * Live Composer Module
 * @since  0.1
 */
function btnsx_lc() {
	// Check if Live Composer is active
	if ( defined( 'DS_LIVE_COMPOSER_URL' ) ) {
		if( class_exists( 'Btnsx' )  ) {
			global $btnsx_settings;
			// Register Modules
		    add_action( 'dslc_hook_register_modules',
		        create_function( '', 'return dslc_register_module( "Btnsx_LC_Module" );' )
		    );
		    if( isset( $btnsx_settings['dual_buttons'] ) && $btnsx_settings['dual_buttons'] === '1' ) {
			    add_action( 'dslc_hook_register_modules',
			        create_function( '', 'return dslc_register_module( "Btnsx_Dual_LC_Module" );' )
			    );
			}
			if( isset( $btnsx_settings['social_buttons'] ) && $btnsx_settings['social_buttons'] === '1' ) {
			    add_action( 'dslc_hook_register_modules',
			        create_function( '', 'return dslc_register_module( "Btnsx_Social_LC_Module" );' )
			    );
			}
			if( isset( $btnsx_settings['social_counters'] ) && $btnsx_settings['social_counters'] === '1' ) {
			    add_action( 'dslc_hook_register_modules',
			        create_function( '', 'return dslc_register_module( "Btnsx_Counters_LC_Module" );' )
			    );
			}
		} else {
			add_action( 'admin_notices', 'btnsx_lc_dependency_notice' );
		}
	    class Btnsx_LC_Module extends DSLC_Module {
	        // Module Attributes
	        var $module_id = 'Btnsx_LC_Module';
	        var $module_title = 'Buttons';
	        var $module_icon = 'circle';
	        var $module_category = 'buttons x';
	        // Module Options
	        function options() { 

	            $buttons = btnsx_lc_post_types( 'buttons-x' );

	            // The options array
	            $options = array(
	                array(
	                    'label' => __('Button','btnsx-lc'),
	                    'id' => 'btnsx',
	                    'std' => $buttons[0]['value'],
	                    'type' => 'select',
	                    'choices' => $buttons
	                ),
	         		array(
	            		'label' => __('Text','btnsx-lc'),
	                    'id' => 'btnsx_text',
	                    'std' => '',
	                    'type' => 'text',
	            	),
	            	array(
	            		'label' => __('Custom Class','btnsx-lc'),
	                    'id' => 'btnsx_class',
	                    'std' => '',
	                    'type' => 'text',
	            	),
	            	array(
	                    'label' => __('Link Target','btnsx-lc'),
	                    'id' => 'btnsx_link_target',
	                    'std' => '',
	                    'type' => 'select',
	                    'choices' => array(
	                    	array(
	                    		'label' => __( 'Default', 'btnsx-lc' ),
	                    		'value' => ''
	                    	),
	                    	array(
	                    		'label' => __( 'New Window', 'btnsx-lc' ),
	                    		'value' => 'new_window'
	                    	),
	                    	array(
	                    		'label' => __( 'Same Window', 'btnsx-lc' ),
	                    		'value' => 'same_window'
	                    	),
	                    	array(
	                    		'label' => __( 'Iframe', 'btnsx-lc' ),
	                    		'value' => 'iframe'
	                    	)
						),
						'tab' => __( 'Link', 'btnsx-lc' )
	                ),
	                array(
	                    'label' => __('Link Relationship','btnsx-lc'),
	                    'id' => 'btnsx_link_relationship',
	                    'std' => '',
	                    'type' => 'select',
	                    'choices' => array(
	                    	array(
	                    		'label' => __( 'None', 'btnsx-lc' ),
	                    		'value' => ''
	                    	),
	                    	array(
	                    		'label' => __( 'Alternate', 'btnsx-lc' ),
	                    		'value' => 'alternate'
	                    	),
							array(
	                    		'label' => __( 'Author', 'btnsx-lc' ),
	                    		'value' => 'author'
	                    	),
	                    	array(
	                    		'label' => __( 'Bookmark', 'btnsx-lc' ),
	                    		'value' => 'bookmark'
	                    	),
							array(
	                    		'label' => __( 'Help', 'btnsx-lc' ),
	                    		'value' => 'help'
	                    	),
							array(
	                    		'label' => __( 'License', 'btnsx-lc' ),
	                    		'value' => 'license'
	                    	),
							array(
	                    		'label' => __( 'Next', 'btnsx-lc' ),
	                    		'value' => 'next'
	                    	),
							array(
	                    		'label' => __( 'Nofollow', 'btnsx-lc' ),
	                    		'value' => 'nofollow'
	                    	),
							array(
	                    		'label' => __( 'No Referrer', 'btnsx-lc' ),
	                    		'value' => 'noreferrer'
	                    	),
							array(
	                    		'label' => __( 'Prefetch', 'btnsx-lc' ),
	                    		'value' => 'prefetch'
	                    	),
							array(
	                    		'label' => __( 'Previous', 'btnsx-lc' ),
	                    		'value' => 'prev'
	                    	),
							array(
	                    		'label' => __( 'Search', 'btnsx-lc' ),
	                    		'value' => 'search'
	                    	),
							array(
	                    		'label' => __( 'Tag', 'btnsx-lc' ),
	                    		'value' => 'tag'
	                    	)
						),
						'tab' => __( 'Link', 'btnsx-lc' )
	                ),
					array(
	                    'label' => __('Link Type','btnsx-lc'),
	                    'id' => 'btnsx_link_type',
	                    'std' => '',
	                    'type' => 'select',
	                    'choices' => array(
	                    	array(
	                    		'label' => __( 'None', 'btnsx-lc' ),
	                    		'value' => 'none'
	                    	),
	                    	array(
	                    		'label' => __( 'Admin Page', 'btnsx-lc' ),
	                    		'value' => 'admin_page'
	                    	),
							array(
	                    		'label' => __( 'Back To Top', 'btnsx-lc' ),
	                    		'value' => 'back_to_top'
	                    	),
	                    	array(
	                    		'label' => __( 'EDD - Checkout', 'btnsx-lc' ),
	                    		'value' => 'edd_checkout'
	                    	),
							array(
	                    		'label' => __( 'EDD - Staright to Gateway', 'btnsx-lc' ),
	                    		'value' => 'edd_straight_to_gateway'
	                    	),
	                    	array(
	                    		'label' => __( 'Facebook Share', 'btnsx-lc' ),
	                    		'value' => 'facebook_share'
	                    	),
							array(
	                    		'label' => __( 'Home Page', 'btnsx-lc' ),
	                    		'value' => 'home_page'
	                    	),
							array(
	                    		'label' => __( 'Login Page', 'btnsx-lc' ),
	                    		'value' => 'login'
	                    	),
							array(
	                    		'label' => __( 'Login - Redirect to Current Page', 'btnsx-lc' ),
	                    		'value' => 'login_redirect_current_page'
	                    	),
							array(
	                    		'label' => __( 'Login - Redirect to Home Page', 'btnsx-lc' ),
	                    		'value' => 'login_redirect_home_page'
	                    	),
							array(
	                    		'label' => __( 'Login - Redirect to Custom Page', 'btnsx-lc' ),
	                    		'value' => 'login_redirect_custom_page'
	                    	),
							array(
	                    		'label' => __( 'Logout Page', 'btnsx-lc' ),
	                    		'value' => 'logout'
	                    	),
							array(
	                    		'label' => __( 'Logout - Redirect to Current Page', 'btnsx-lc' ),
	                    		'value' => 'logout_redirect_current_page'
	                    	),
	                    	array(
	                    		'label' => __( 'Logout - Redirect to Home Page', 'btnsx-lc' ),
	                    		'value' => 'logout_redirect_home_page'
	                    	),
							array(
	                    		'label' => __( 'Logout - Redirect to Custom Page', 'btnsx-lc' ),
	                    		'value' => 'logout_redirect_custom_page'
	                    	),
	                    	array(
	                    		'label' => __( 'Lost Password Page', 'btnsx-lc' ),
	                    		'value' => 'lost_password'
	                    	),
							array(
	                    		'label' => __( 'Lost Password - Redirect to Current Page', 'btnsx-lc' ),
	                    		'value' => 'lost_password_redirect_current_page'
	                    	),
	                    	array(
	                    		'label' => __( 'Lost Password - Redirect to Home Page', 'btnsx-lc' ),
	                    		'value' => 'lost_password_redirect_home_page'
	                    	),
							array(
	                    		'label' => __( 'Lost Password - Redirect to Custom Page', 'btnsx-lc' ),
	                    		'value' => 'lost_password_redirect_custom_page'
	                    	),
							array(
	                    		'label' => __( 'Menu', 'btnsx-lc' ),
	                    		'value' => 'menu'
	                    	),
	                    	array(
	                    		'label' => __( 'Pinterest Share', 'btnsx-lc' ),
	                    		'value' => 'pinterest_share'
	                    	),
	                    	array(
	                    		'label' => __( 'Popup Maker', 'btnsx-lc' ),
	                    		'value' => 'popup_maker'
	                    	),
							array(
	                    		'label' => __( 'Post/Page/CPT', 'btnsx-lc' ),
	                    		'value' => 'post'
	                    	),
	                    	array(
	                    		'label' => __( 'Previous Page', 'btnsx-lc' ),
	                    		'value' => 'previous_page'
	                    	),
							array(
	                    		'label' => __( 'Registeration Page', 'btnsx-lc' ),
	                    		'value' => 'register'
	                    	),
	                    	array(
	                    		'label' => __( 'Twitter Share', 'btnsx-lc' ),
	                    		'value' => 'twitter_share'
	                    	),
							array(
	                    		'label' => __( 'URL', 'btnsx-lc' ),
	                    		'value' => 'url'
	                    	),
							array(
	                    		'label' => __( 'Woocommerce - Add to Cart', 'btnsx-lc' ),
	                    		'value' => 'woocommerce_add_to_cart'
	                    	)
						),
						'tab' => __( 'Link', 'btnsx-lc' )
	                ),
					array(
	                    'label' => __('Post / Page / CPT','btnsx-lc'),
	                    'id' => 'btnsx_link_post',
	                    'std' => '',
	                    'type' => 'select',
	                    'choices' => btnsx_lc_post_links(),
						'tab' => __( 'Link', 'btnsx-lc' )
	                ),
	                array(
	                    'label' => __('Menu as Dropdown','btnsx-lc'),
	                    'id' => 'btnsx_link_menu',
	                    'std' => '',
	                    'type' => 'select',
	                    'choices' => btnsx_lc_menus(),
						'tab' => __( 'Link', 'btnsx-lc' )
	                ),
	                array(
	                    'label' => __('Choose Popup','btnsx-lc'),
	                    'id' => 'btnsx_link_popup_maker',
	                    'std' => '',
	                    'type' => 'select',
	                    'choices' => btnsx_lc_post_types( 'popup' ),
						'tab' => __( 'Link', 'btnsx-lc' )
	                ),
	                array(
	                    'label' => __('Menu Display','btnsx-lc'),
	                    'id' => 'btnsx_link_menu_display',
	                    'std' => '',
	                    'type' => 'select',
	                    'choices' => array(
	                    	array(
	                    		'label' => __( 'On Click', 'btnsx-lc' ),
	                    		'value' => 'on_click'
	                    	),
	                    	array(
	                    		'label' => __( 'On Hover', 'btnsx-lc' ),
	                    		'value' => 'on_hover'
	                    	)
						),
						'tab' => __( 'Link', 'btnsx-lc' )
	                ),
	                array(
	            		'label' => __('URL','btnsx-lc'),
	                    'id' => 'btnsx_link',
	                    'std' => '',
	                    'type' => 'text',
	                    'tab' => __( 'Link', 'btnsx-lc' )
	            	),
	            	array(
	                    'label' => __('EDD Product ID','btnsx-lc'),
	                    'id' => 'btnsx_link_edd_id',
	                    'std' => '',
	                    'type' => 'select',
	                    'choices' => btnsx_lc_post_types( 'download' ),
						'tab' => __( 'Link', 'btnsx-lc' )
	                ),
	                array(
	            		'label' => __('Redirect URL','btnsx-lc'),
	                    'id' => 'btnsx_link_redirect_url',
	                    'std' => '',
	                    'type' => 'text',
	                    'tab' => __( 'Link', 'btnsx-lc' )
	            	),
	            	array(
	                    'label' => __('WooCommerce Product ID','btnsx-lc'),
	                    'id' => 'btnsx_link_woocommerce_id',
	                    'std' => '',
	                    'type' => 'select',
	                    'choices' => btnsx_lc_post_types( 'product' ),
						'tab' => __( 'Link', 'btnsx-lc' )
	                ),
	                array(
	            		'label' => __('Full Width','btnsx-lc'),
	                    'id' => 'btnsx_full_width',
	                    'std' => '',
	                    'type' => 'select',
	                    'tab' => __( 'Layout', 'btnsx-lc' ),
	                    'choices' => array(
	                    	array(
								'label' => __( 'Default', 'btnsx-lc' ),
								'value' => ''
							),
							array(
								'label' => __( 'Yes', 'btnsx-lc' ),
								'value' => 1
							),
							array(
								'label' => __( 'No', 'btnsx-lc' ),
								'value' => 0
							),
						)
	            	),
	            	array(
	            		'label' => __('Wrap Center','btnsx-lc'),
	                    'id' => 'btnsx_wrap_center',
	                    'std' => '',
	                    'type' => 'select',
	                    'tab' => __( 'Layout', 'btnsx-lc' ),
	                    'choices' => array(
	                    	array(
								'label' => __( 'Default', 'btnsx-lc' ),
								'value' => ''
							),
							array(
								'label' => __( 'Yes', 'btnsx-lc' ),
								'value' => 1
							),
							array(
								'label' => __( 'No', 'btnsx-lc' ),
								'value' => 0
							),
						)
	            	),
	            );
	         
	            // Return the array
	            return apply_filters( 'dslc_module_options', $options, $this->module_id );
	        }
	        // Module Output
	        function output( $options ) {
	 
	            // REQUIRED
	            $this->module_start( $options );
	         
	            // Content
	            echo do_shortcode('[btnsx id="' . $options['btnsx'] . '" text="'. $options['btnsx_text'] .'" class="'. $options['btnsx_class'] .'" link_target="' . $options['btnsx_link_target'] . '" link_relationship="' . $options['btnsx_link_relationship'] . '" link_type="' . $options['btnsx_link_type'] . '" link_post="' . $options['btnsx_link_post'] . '" link_menu="' . $options['btnsx_link_menu'] . '" link_menu_display="' . $options['btnsx_link_menu_display'] . '" link_popup_maker="' . $options['btnsx_link_popup_maker'] . '" link="' . $options['btnsx_link'] . '" link_edd_id="' . $options['btnsx_link_edd_id'] . '" link_woocommerce_id="' . $options['btnsx_link_woocommerce_id'] . '" link_redirect_url="' . $options['btnsx_link_redirect_url'] . '" full_width="' . $options['btnsx_full_width'] . '" wrap_center="' . $options['btnsx_wrap_center'] . '"]');
	         
	            // REQUIRED
	            $this->module_end( $options );
	         
	        }
	    }
	    class Btnsx_Dual_LC_Module extends DSLC_Module {
	        // Module Attributes
	        var $module_id = 'Btnsx_Dual_LC_Module';
	        var $module_title = 'Dual Buttons';
	        var $module_icon = 'circle';
	        var $module_category = 'buttons x';
	        // Module Options
	        function options() {

	            $buttons = btnsx_lc_post_types( 'buttons-x-dual' );

	            // The options array
	            $options = array(
	                array(
	                    'label' => 'Buttons',
	                    'id' => 'btnsx',
	                    'std' => $buttons[0]['value'],
	                    'type' => 'select',
	                    'choices' => $buttons
	                ),
	         
	            );
	         
	            // Return the array
	            return apply_filters( 'dslc_module_options', $options, $this->module_id );
	        }
	        // Module Output
	        function output( $options ) {
	 
	            // REQUIRED
	            $this->module_start( $options );
	         
	            // Content
	            echo do_shortcode('[btnsx_dual id="' . $options['btnsx'] . '"]');
	         
	            // REQUIRED
	            $this->module_end( $options );
	         
	        }
	    }
	    class Btnsx_Social_LC_Module extends DSLC_Module {
	        // Module Attributes
	        var $module_id = 'Btnsx_Social_LC_Module';
	        var $module_title = 'Social Buttons';
	        var $module_icon = 'circle';
	        var $module_category = 'buttons x';
	        // Module Options
	        function options() { 

	            $buttons = btnsx_lc_post_types( 'buttons-x-social' );

	            // The options array
	            $options = array(
	                array(
	                    'label' => 'Buttons',
	                    'id' => 'btnsx',
	                    'std' => $buttons[0]['value'],
	                    'type' => 'select',
	                    'choices' => $buttons
	                ),
	         
	            );
	         
	            // Return the array
	            return apply_filters( 'dslc_module_options', $options, $this->module_id );
	        }
	        // Module Output
	        function output( $options ) {
	 
	            // REQUIRED
	            $this->module_start( $options );
	         
	            // Content
	            echo do_shortcode('[btnsx_social id="' . $options['btnsx'] . '"]');
	         
	            // REQUIRED
	            $this->module_end( $options );
	         
	        }
	    }
	    class Btnsx_Counters_LC_Module extends DSLC_Module {
	        // Module Attributes
	        var $module_id = 'Btnsx_Counters_LC_Module';
	        var $module_title = 'Social Counters';
	        var $module_icon = 'circle';
	        var $module_category = 'buttons x';
	        // Module Options
	        function options() { 

	            $buttons = btnsx_lc_post_types( 'buttons-x-cs' );

	            // The options array
	            $options = array(
	                array(
	                    'label' => 'Buttons',
	                    'id' => 'btnsx',
	                    'std' => $buttons[0]['value'],
	                    'type' => 'select',
	                    'choices' => $buttons
	                ),
	         
	            );
	         
	            // Return the array
	            return apply_filters( 'dslc_module_options', $options, $this->module_id );
	        }
	        // Module Output
	        function output( $options ) {
	 
	            // REQUIRED
	            $this->module_start( $options );
	         
	            // Content
	            echo do_shortcode('[btnsx_social_counter id="' . $options['btnsx'] . '"]');
	         
	            // REQUIRED
	            $this->module_end( $options );
	         
	        }
	    }
	}
}
add_action( 'plugins_loaded', 'btnsx_lc' );

function btnsx_lc_scripts() {
	global $dslc_active;
	if ( $dslc_active && is_user_logged_in() && current_user_can( DS_LIVE_COMPOSER_CAPABILITY ) ) {
		wp_enqueue_script( 'btnsx-lc-js', BTNSX__LC_PLUGIN_URL . 'main.js', array( 'jquery' ), BTNSX__LC_VERSION );
	}
}
add_action( 'wp_enqueue_scripts', 'btnsx_lc_scripts' );

/**
 * Load plugin textdomain
 * @since  0.1
 */
function btnsx_lc_textdomain() {
	load_plugin_textdomain( 'btnsx-analytics', false, BTNSX__LC_PLUGIN_URL . 'languages' );
}
add_action( 'plugins_loaded', 'btnsx_lc_textdomain' );

/**
 * Buttons X dependency notice
 */
function btnsx_lc_dependency_notice() {
	$class = 'update-nag';
	$url = 'https://www.button.sx';
	$message = sprintf( __( '<strong>Buttons X Live Composer</strong> add-on is not really useful without <strong><a target="_blank" href="%s">Buttons X</a></strong> plugin.', 'btnsx-lc' ), $url );
    echo '<div class="' . $class . '"><p>' . $message . '</p></div>'; 
}